/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.web;

import cn.funnymap.lgis.spring.SpringContextHolder;
import com.alibaba.fastjson2.JSONObject;
import java.net.URI;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private static final RestTemplate REST_TEMPLATE = SpringContextHolder.getBean(RestTemplate.class);

    private RestTemplateUtil() {
    }

    public static JSONObject queryAsJson(URI uri) throws ResourceAccessException {
        String serviceInfoResponseBody = (String)REST_TEMPLATE.getForEntity(uri, String.class).getBody();
        return JSONObject.parseObject((String)serviceInfoResponseBody);
    }

    public static JSONObject queryAsJson(String url, HttpMethod httpMethod, HttpEntity<?> httpEntity) {
        String response = (String)REST_TEMPLATE.exchange(url, httpMethod, httpEntity, String.class, new Object[0]).getBody();
        return JSONObject.parseObject((String)response);
    }

    @ConditionalOnClass(value={DocumentHelper.class})
    public static Document queryAsXmlDocument(URI uri) throws DocumentException {
        String responseBody = (String)REST_TEMPLATE.getForEntity(uri, String.class).getBody();
        if (responseBody != null) {
            return DocumentHelper.parseText((String)responseBody);
        }
        return null;
    }
}

