/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.utils;

import cn.funnymap.lgis.response.exception.common.ParamValidationException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.ValidationException;

public class DateUtil {
    private static final String DATA_STR_FORMAT = "yyyy-MM-dd";
    private static final String DATE_TIME_STR_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private DateUtil() {
    }

    public static Date str2Date(String dateAsStr) throws ParseException {
        return DateUtil.strToDate(dateAsStr, DATA_STR_FORMAT);
    }

    public static Date strToDate(String dateAsStr, String format) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.parse(dateAsStr);
    }

    public static String date2str(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATA_STR_FORMAT);
        return simpleDateFormat.format(date);
    }

    public static String date2str(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static LocalDateTime str2LocalDateTime(String dateTimeAsStr) {
        return DateUtil.str2LocalDateTime(dateTimeAsStr, DATE_TIME_STR_FORMAT);
    }

    public static LocalDateTime str2LocalDateTime(String dateTimeAsStr, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return LocalDateTime.parse(dateTimeAsStr, formatter);
    }

    public static String localDateTime2Str(LocalDateTime localDateTime) {
        return DateUtil.localDateTime2Str(localDateTime, DATE_TIME_STR_FORMAT);
    }

    public static String localDateTime2Str(LocalDateTime localDateTime, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return localDateTime.format(formatter);
    }

    public static List<Date> dateRangeDto2DateList(String from, String to) throws ParseException {
        if (from == null || from.isEmpty() || to == null || to.isEmpty()) {
            return new ArrayList<Date>();
        }
        ArrayList<Date> dateList = new ArrayList<Date>();
        dateList.add(DateUtil.str2Date(from));
        dateList.add(DateUtil.str2Date(to));
        return dateList;
    }

    public static void dateFormatValidation(String from, String to) {
        String validationRegRule = "\\d{4}-\\d{2}-\\d{2}";
        Pattern pattern = Pattern.compile(validationRegRule);
        if (!pattern.matcher(from).matches() || !pattern.matcher(to).matches()) {
            throw new ValidationException("\u8d77\u59cb\u65e5\u671f\u548c\u622a\u6b62\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u65e5\u671f\u683c\u5f0f\u662f\u5426\u4e3a YYYY-MM-DD");
        }
    }

    public static void sequentialValidation(String from, String to) throws ParseException {
        Date toDate;
        Date fromDate = DateUtil.str2Date(from);
        if (fromDate.compareTo(toDate = DateUtil.str2Date(to)) > 0) {
            throw new ParamValidationException("\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8d77\u59cb\u65e5\u671f");
        }
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date plus(Integer value) {
        return Date.from(LocalDateTime.now().plusDays(value.intValue()).atZone(ZoneId.systemDefault()).toInstant());
    }
}

