/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanCopyUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanCopyUtils.class);

    private BeanCopyUtils() {
    }

    public static <V> V copyBean(Object source, Class<V> clazz) {
        V result = null;
        try {
            result = clazz.newInstance();
            BeanUtils.copyProperties((Object)source, result);
        }
        catch (Exception e) {
            log.error("BeanCopyUtils.copyBean error", (Throwable)e);
        }
        return result;
    }

    public static <O, V> List<V> copyBeanList(List<O> list, Class<V> clazz) {
        return list.stream().map(o -> BeanCopyUtils.copyBean(o, clazz)).collect(Collectors.toList());
    }
}

