/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.redis;

import cn.funnymap.lgis.redis.CustomGenericJackson2JsonRedisSerializer;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@ConditionalOnClass(value={RedisTemplate.class})
@Configuration
public class RedisConfig {
    @Resource
    RedisConnectionFactory redisConnectionFactory;

    @Bean
    public RedisTemplate<String, Object> redisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        CustomGenericJackson2JsonRedisSerializer jackson2JsonRedisSerializer = new CustomGenericJackson2JsonRedisSerializer();
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }
}

