/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.redis;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

@ConditionalOnClass(value={RedisTemplate.class, ObjectMapper.class, PolymorphicTypeValidator.class})
public class CustomGenericJackson2JsonRedisSerializer
extends GenericJackson2JsonRedisSerializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public CustomGenericJackson2JsonRedisSerializer() {
        super(OBJECT_MAPPER);
    }

    public byte[] serialize(Object source) throws SerializationException {
        if (source instanceof String) {
            return ((String)source).getBytes(StandardCharsets.UTF_8);
        }
        try {
            return OBJECT_MAPPER.writeValueAsBytes(source);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize: " + e.getMessage(), (Throwable)e);
        }
    }

    public Object deserialize(byte[] source) throws SerializationException {
        if (source == null || source.length == 0) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(source, Object.class);
        }
        catch (Exception e) {
            throw new SerializationException("Could not deserialize: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        OBJECT_MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        OBJECT_MAPPER.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
    }
}

