/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.params.validation;

import cn.funnymap.lgis.params.validation.MultipartFileExtensionAnno;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.web.multipart.MultipartFile;

@ConditionalOnClass(value={Constraint.class})
public class MultipartFileExtensionValidator
implements ConstraintValidator<MultipartFileExtensionAnno, Object> {
    private final Set<String> supportFileTypes = new HashSet<String>();

    public void initialize(MultipartFileExtensionAnno constraintAnnotation) {
        String[] vals;
        for (String val : vals = constraintAnnotation.value()) {
            this.supportFileTypes.add(val.toLowerCase());
        }
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value instanceof List) {
            for (Object item : (List)value) {
                if (item instanceof MultipartFile) {
                    boolean temp = this.validateMultipartFileExtension((MultipartFile)item);
                    if (temp) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        if (value instanceof MultipartFile) {
            return this.validateMultipartFileExtension((MultipartFile)value);
        }
        return false;
    }

    private boolean validateMultipartFileExtension(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName == null) {
            return false;
        }
        String fileExtension = this.getFileExtension(fileName);
        return this.supportFileTypes.contains(fileExtension.toLowerCase());
    }

    private String getFileExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return "";
        }
        return fileName.substring(lastDotIndex + 1).toLowerCase();
    }
}

