/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.mp.operator;

import cn.funnymap.lgis.mp.entity.BaseCatalogNodeEntity;
import cn.funnymap.lgis.mp.operator.CatalogEntityConverter;
import cn.funnymap.lgis.mp.operator.CatalogNodeVO;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUtil {
    private static final Logger log = LoggerFactory.getLogger(CatalogUtil.class);

    private CatalogUtil() {
    }

    public static <T extends BaseCatalogNodeEntity, V extends CatalogNodeVO> V asTree(List<T> entityList, CatalogEntityConverter<T, V> converter) {
        return CatalogUtil.asTree(entityList, converter, false);
    }

    public static <T extends BaseCatalogNodeEntity, V extends CatalogNodeVO> V asTree(List<T> entityList, CatalogEntityConverter<T, V> converter, boolean firstIsRoot) {
        Map voMap = entityList.stream().collect(Collectors.toMap(BaseCatalogNodeEntity::getPath, converter::execute, (a, b) -> a, LinkedHashMap::new));
        return CatalogUtil.flatVoMap(entityList, voMap, firstIsRoot);
    }

    private static <T extends BaseCatalogNodeEntity, V extends CatalogNodeVO> V flatVoMap(List<T> entityList, Map<String, V> voMap, boolean firstIsRoot) {
        CatalogNodeVO vo = null;
        if (firstIsRoot) {
            vo = (CatalogNodeVO)voMap.get(((BaseCatalogNodeEntity)entityList.get(0)).getPath());
        }
        for (BaseCatalogNodeEntity entity : entityList) {
            String path = entity.getPath();
            if ("root".equals(entity.getLevel()) && !firstIsRoot) {
                vo = (CatalogNodeVO)voMap.get(path);
                continue;
            }
            String parentNodePath = path.substring(0, path.lastIndexOf("."));
            CatalogNodeVO parentNodeVo = (CatalogNodeVO)voMap.get(parentNodePath);
            if (parentNodeVo == null) continue;
            parentNodeVo.getChildren().add((CatalogNodeVO)voMap.get(path));
        }
        return (V)vo;
    }

    public static String getParentNodePath(String path) {
        String[] pathItems = path.split("\\.");
        if (pathItems.length >= 2) {
            return pathItems[pathItems.length - 2];
        }
        return null;
    }
}

