/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.mp.ltree.service;

import cn.funnymap.lgis.mp.ltree.enums.LtreeMoveTypeEnum;
import cn.funnymap.lgis.mp.ltree.mapper.LTreeBaseMapper;
import cn.funnymap.lgis.mp.ltree.pojo.dto.LTreeDTO;
import cn.funnymap.lgis.mp.ltree.pojo.dto.MoveNodeDTO;
import cn.funnymap.lgis.mp.ltree.pojo.entity.LTreeBaseEntity;
import cn.funnymap.lgis.mp.ltree.pojo.vo.LTreeBaseVO;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

public class LTreeServiceImpl<M extends LTreeBaseMapper<E>, E extends LTreeBaseEntity, V extends LTreeBaseVO<V>>
extends ServiceImpl<LTreeBaseMapper<E>, E> {
    @Resource
    private LTreeBaseMapper<E> mapper;
    @Resource
    private ApplicationContext applicationContext;

    public V getById(String id, Class<V> voClazz, Class<E> entityClazz) {
        String tableName = entityClazz.getAnnotation(TableName.class).value();
        List<E> entities = this.mapper.getSelfAndChildrenById(id, tableName);
        return this.buildTreeVO(entities, id, voClazz);
    }

    private V buildTreeVO(List<E> entities, String rootId, Class<V> voClazz) {
        HashMap<String, List> nodeMap = new HashMap<String, List>();
        LTreeBaseVO rootVO = null;
        try {
            for (LTreeBaseEntity entity : entities) {
                if (entity.getId().equals(rootId)) {
                    rootVO = (LTreeBaseVO)voClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    BeanUtils.copyProperties((Object)entity, (Object)rootVO);
                    rootVO.setChildren(new ArrayList());
                    continue;
                }
                LTreeBaseVO vo = (LTreeBaseVO)voClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                BeanUtils.copyProperties((Object)entity, (Object)vo);
                vo.setChildren(new ArrayList());
                String[] paths = entity.getPath().split("\\.");
                String parentId = paths[paths.length - 2];
                List children = nodeMap.computeIfAbsent(parentId, k -> new ArrayList());
                children.add(vo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (rootVO == null) {
            throw new RuntimeException("\u6ca1\u6709\u6839\u8282\u70b9");
        }
        ArrayDeque<LTreeBaseVO> stack = new ArrayDeque<LTreeBaseVO>();
        stack.push(rootVO);
        while (!stack.isEmpty()) {
            LTreeBaseVO currentNode = (LTreeBaseVO)stack.pop();
            List children = nodeMap.getOrDefault(currentNode.getId(), new ArrayList());
            currentNode.setChildren(children);
            stack.addAll(children);
        }
        return (V)rootVO;
    }

    public void addNode(E e, LTreeDTO ltreeDTO, Class<E> entityClazz) {
        String tableName = entityClazz.getAnnotation(TableName.class).value();
        LTreeBaseEntity parentNode = (LTreeBaseEntity)this.mapper.selectById((Serializable)((Object)ltreeDTO.getParentNodeId()));
        if (parentNode == null || parentNode.getPath() == null) {
            throw new RuntimeException("\u7236\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u4e0d\u5408\u6cd5");
        }
        List<E> nextLevelNodes = this.mapper.queryNextLevelNodesByPath(parentNode.getPath(), tableName);
        Integer maxSort = nextLevelNodes.stream().map(LTreeBaseEntity::getSort).max(Comparator.naturalOrder()).orElse(0);
        String id = UUID.randomUUID().toString().replace("-", "");
        ((LTreeBaseEntity)e).setId(id);
        ((LTreeBaseEntity)e).setName(ltreeDTO.getName());
        ((LTreeBaseEntity)e).setPath(parentNode.getPath() + "." + id);
        ((LTreeBaseEntity)e).setSort(maxSort + 1);
        this.save(e);
    }

    public void batchInsertNodeBySameParentNode(List<E> entities, Class<E> entityClazz) {
        String tableName = entityClazz.getAnnotation(TableName.class).value();
        String[] paths = ((LTreeBaseEntity)entities.get(0)).getPath().split("\\.");
        LTreeBaseEntity parentNode = (LTreeBaseEntity)this.mapper.selectById((Serializable)((Object)paths[paths.length - 2]));
        if (parentNode == null || parentNode.getPath() == null) {
            throw new RuntimeException("\u7236\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u4e0d\u5408\u6cd5");
        }
        List<E> nextLevelNodes = this.mapper.queryNextLevelNodesByPath(parentNode.getPath(), tableName);
        int maxSort = nextLevelNodes.stream().map(LTreeBaseEntity::getSort).max(Comparator.naturalOrder()).orElse(0);
        for (int i = 0; i < entities.size(); ++i) {
            ((LTreeBaseEntity)entities.get(i)).setSort(maxSort + i + 1);
        }
        this.saveBatch(entities);
    }

    public void deleteNode(String id, Class<E> entityClazz) {
        String tableName = entityClazz.getAnnotation(TableName.class).value();
        this.mapper.deleteByIdAndChildren(id, tableName);
    }

    public void logicDeleteNode(String id, Class<E> entityClazz) {
        String tableName = entityClazz.getAnnotation(TableName.class).value();
        this.mapper.logicDeleteNodeById(id, tableName);
    }

    public void moveNode(MoveNodeDTO moveNodeDTO, String rootId, Class<E> entityClazz) {
        String tableName = entityClazz.getAnnotation(TableName.class).value();
        String movedId = moveNodeDTO.getMovedId();
        String targetId = moveNodeDTO.getTargetId();
        LTreeBaseEntity movedLTreeEntity = (LTreeBaseEntity)this.mapper.selectById((Serializable)((Object)movedId));
        LTreeBaseEntity targetLTreeEntity = (LTreeBaseEntity)this.mapper.selectById((Serializable)((Object)targetId));
        this.parameterVerify(movedId, targetId, moveNodeDTO.getMoveType(), movedLTreeEntity, targetLTreeEntity, rootId);
        switch (moveNodeDTO.getMoveType()) {
            case INNER: {
                LTreeServiceImpl proxyObject = (LTreeServiceImpl)((Object)this.applicationContext.getBean(LTreeServiceImpl.class));
                proxyObject.movedInnerTargetNode(movedLTreeEntity, targetLTreeEntity, tableName);
                break;
            }
            case BEFORE: {
                this.movedBeforeTargetNode(movedLTreeEntity, targetLTreeEntity, tableName);
                break;
            }
            case AFTER: {
                this.movedAfterTargetNode(movedLTreeEntity, targetLTreeEntity, tableName);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u79fb\u52a8\u7c7b\u578b");
            }
        }
    }

    @Transactional
    public void movedInnerTargetNode(E movedLTreeEntity, E targetLTreeEntity, String tableName) {
        String movedId = ((LTreeBaseEntity)movedLTreeEntity).getId();
        List<E> lTreeEntities = this.mapper.getSelfAndChildrenById(movedId, tableName);
        E movedParentNode = this.mapper.getParentByChildId(movedId, tableName);
        List<E> nextLevelNodes = this.mapper.queryNextLevelNodesByPath(((LTreeBaseEntity)targetLTreeEntity).getPath(), tableName);
        int maxSort = nextLevelNodes.stream().map(LTreeBaseEntity::getSort).max(Comparator.naturalOrder()).orElse(0);
        for (LTreeBaseEntity entity : lTreeEntities) {
            entity.setPath(((LTreeBaseEntity)targetLTreeEntity).getPath() + entity.getPath().replace(((LTreeBaseEntity)movedParentNode).getPath(), ""));
            if (entity.getId().equals(movedId)) {
                entity.setSort(maxSort + 1);
            }
            this.mapper.updateById(entity);
        }
    }

    private void movedBeforeTargetNode(E movedLTreeEntity, E targetLTreeEntity, String tableName) {
        String movedId = ((LTreeBaseEntity)movedLTreeEntity).getId();
        String targetId = ((LTreeBaseEntity)targetLTreeEntity).getId();
        E targetParentNode = this.mapper.getParentByChildId(targetId, tableName);
        E movedParentNode = this.mapper.getParentByChildId(movedId, tableName);
        if (((LTreeBaseEntity)targetParentNode).getId().equals(((LTreeBaseEntity)movedParentNode).getId())) {
            this.movedAfterOrBeforeFromSameParentNode(movedLTreeEntity, targetLTreeEntity, movedId, targetId, 0, tableName);
        } else {
            LTreeServiceImpl proxyObject = (LTreeServiceImpl)((Object)this.applicationContext.getBean(LTreeServiceImpl.class));
            proxyObject.movedAfterOrBeforeFromDifferentParentNode(movedLTreeEntity, targetLTreeEntity, movedId, targetId, targetParentNode, movedParentNode, 0, tableName);
        }
    }

    private void movedAfterTargetNode(E movedLTreeEntity, E targetLTreeEntity, String tableName) {
        String movedId = ((LTreeBaseEntity)movedLTreeEntity).getId();
        String targetId = ((LTreeBaseEntity)targetLTreeEntity).getId();
        E targetParentNode = this.mapper.getParentByChildId(targetId, tableName);
        E movedParentNode = this.mapper.getParentByChildId(movedId, tableName);
        if (((LTreeBaseEntity)targetParentNode).getId().equals(((LTreeBaseEntity)movedParentNode).getId())) {
            this.movedAfterOrBeforeFromSameParentNode(movedLTreeEntity, targetLTreeEntity, movedId, targetId, 1, tableName);
        } else {
            LTreeServiceImpl proxyObject = (LTreeServiceImpl)((Object)this.applicationContext.getBean(LTreeServiceImpl.class));
            proxyObject.movedAfterOrBeforeFromDifferentParentNode(movedLTreeEntity, targetLTreeEntity, movedId, targetId, targetParentNode, movedParentNode, 1, tableName);
        }
    }

    @Transactional
    public void movedAfterOrBeforeFromDifferentParentNode(E movedLTreeEntity, E targetLTreeEntity, String movedId, String targetId, E targetParentNode, E movedParentNode, Integer index, String tableName) {
        List<E> movedChildrenEntities = this.mapper.getNoSelfAndChildrenById(movedId, tableName);
        for (LTreeBaseEntity movedEntity : movedChildrenEntities) {
            movedEntity.setPath(((LTreeBaseEntity)targetParentNode).getPath() + movedEntity.getPath().replace(((LTreeBaseEntity)movedParentNode).getPath(), ""));
            this.mapper.updateById(movedEntity);
        }
        ((LTreeBaseEntity)movedLTreeEntity).setPath(((LTreeBaseEntity)targetParentNode).getPath() + ((LTreeBaseEntity)movedLTreeEntity).getPath().replace(((LTreeBaseEntity)movedParentNode).getPath(), ""));
        List<E> brotherNodes = this.mapper.queryBrotherNodesGTSort(targetId, ((LTreeBaseEntity)targetLTreeEntity).getSort(), tableName);
        LTreeServiceImpl proxyObject = (LTreeServiceImpl)((Object)this.applicationContext.getBean(LTreeServiceImpl.class));
        proxyObject.updateMovedNodeIndexInSameLayer(movedLTreeEntity, index, ((LTreeBaseEntity)targetLTreeEntity).getSort(), brotherNodes);
    }

    private void movedAfterOrBeforeFromSameParentNode(E movedLTreeEntity, E targetLTreeEntity, String movedId, String targetId, Integer index, String tableName) {
        List<E> brotherNodes;
        if (((LTreeBaseEntity)targetLTreeEntity).getSort() > ((LTreeBaseEntity)movedLTreeEntity).getSort()) {
            brotherNodes = this.mapper.queryBrotherNodesGTSort(movedId, ((LTreeBaseEntity)targetLTreeEntity).getSort(), tableName);
        } else {
            Integer minSort = ((LTreeBaseEntity)targetLTreeEntity).getSort();
            Integer maxSort = ((LTreeBaseEntity)targetLTreeEntity).getSort();
            brotherNodes = this.mapper.queryBrotherNodesNoSelfBetweenSort(movedId, minSort, maxSort, tableName);
        }
        LTreeServiceImpl proxyObject = (LTreeServiceImpl)((Object)this.applicationContext.getBean(LTreeServiceImpl.class));
        proxyObject.updateMovedNodeIndexInSameLayer(movedLTreeEntity, index, ((LTreeBaseEntity)targetLTreeEntity).getSort(), brotherNodes);
    }

    @Transactional
    public void updateMovedNodeIndexInSameLayer(E movedLtreeEntity, Integer index, Integer minSort, List<E> brotherNodes) {
        int targetIndex = 0;
        brotherNodes.add(targetIndex + index, movedLtreeEntity);
        for (int i = 0; i < brotherNodes.size() && (i < 2 || minSort + i - 1 == ((LTreeBaseEntity)brotherNodes.get(i)).getSort()); ++i) {
            LTreeBaseEntity ltreeEntity = (LTreeBaseEntity)brotherNodes.get(i);
            ltreeEntity.setSort(minSort + i);
            this.mapper.updateById(ltreeEntity);
        }
    }

    private void parameterVerify(String movedId, String targetId, LtreeMoveTypeEnum moveType, E movedLtreeEntity, E targetLtreeEntity, String rootId) {
        if (rootId.equals(movedId)) {
            throw new RuntimeException("\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u52a8");
        }
        if (movedLtreeEntity == null) {
            throw new RuntimeException("\u88ab\u79fb\u52a8\u7684\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        if (targetLtreeEntity == null) {
            throw new RuntimeException("\u88ab\u79fb\u52a8\u7684\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        if (rootId.equals(targetId) && !moveType.equals((Object)LtreeMoveTypeEnum.INNER)) {
            throw new RuntimeException("\u4e0d\u80fd\u79fb\u52a8\u5230\u6839\u8282\u70b9\u7684\u524d\u540e");
        }
        if (movedId.equals(targetId)) {
            throw new RuntimeException("\u79fb\u52a8\u7684\u8282\u70b9\u548c\u76ee\u6807\u8282\u70b9\u4e0d\u80fd\u76f8\u540c");
        }
        if (((LTreeBaseEntity)targetLtreeEntity).getPath().contains(((LTreeBaseEntity)movedLtreeEntity).getPath())) {
            throw new RuntimeException("\u76ee\u6807\u8282\u70b9\u4e0d\u80fd\u662f\u79fb\u52a8\u8282\u70b9\u7684\u5b50\u8282\u70b9");
        }
    }
}

