/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.file.excel;

import cn.funnymap.lgis.file.excel.ExcelTreeItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ExcelOperator {
    private ExcelOperator() {
    }

    public static List<ExcelTreeItem> readAsTree(Path excelFilePath, Integer sheetIndex, Boolean firstRowIsTitle) throws IOException {
        Workbook workbook = ExcelOperator.generateWorkbook(excelFilePath);
        return ExcelOperator.readContentAsTree(workbook, sheetIndex, firstRowIsTitle);
    }

    public static List<ExcelTreeItem> readAsTree(MultipartFile multipartFile, Integer sheetIndex, Boolean firstRowIsTitle) throws IOException {
        Workbook workbook = ExcelOperator.generateWorkbook(multipartFile);
        return ExcelOperator.readContentAsTree(workbook, sheetIndex, firstRowIsTitle);
    }

    private static Workbook generateWorkbook(MultipartFile multipartFile) throws IOException {
        return WorkbookFactory.create((InputStream)multipartFile.getInputStream());
    }

    private static Workbook generateWorkbook(Path excelFilePath) throws IOException {
        return WorkbookFactory.create((File)excelFilePath.toFile());
    }

    private static List<ExcelTreeItem> readContentAsTree(Workbook workbook, Integer sheetIndex, Boolean firstRowIsTitle) {
        Sheet sheet = workbook.getSheetAt(sheetIndex.intValue());
        ArrayList<ExcelTreeItem> excelTreeItemList = new ArrayList<ExcelTreeItem>();
        if (Boolean.TRUE.equals(firstRowIsTitle)) {
            sheet.removeRow(sheet.getRow(0));
        }
        for (Row row : sheet) {
            ExcelTreeItem tempItem = null;
            for (Cell cell : row) {
                String cellValue = ExcelOperator.readCellValueAsString(sheet, cell);
                if (!StringUtils.hasLength((String)cellValue)) continue;
                if (cell.getColumnIndex() == 0) {
                    tempItem = excelTreeItemList.stream().filter(item -> Objects.equals(item.getValue(), cellValue)).findAny().orElseGet(() -> {
                        excelTreeItemList.add(new ExcelTreeItem(cellValue));
                        return (ExcelTreeItem)excelTreeItemList.get(excelTreeItemList.size() - 1);
                    });
                    continue;
                }
                assert (tempItem != null);
                ExcelTreeItem excelTreeItem = tempItem.getChildren().stream().filter(item -> Objects.equals(item.getValue(), cellValue)).findAny().orElse(null);
                if (excelTreeItem == null) {
                    excelTreeItem = new ExcelTreeItem(cellValue);
                    tempItem.getChildren().add(excelTreeItem);
                }
                tempItem = excelTreeItem;
            }
        }
        return excelTreeItemList;
    }

    private static String readCellValueAsString(Sheet sheet, Cell cell) {
        CellAddress mergedRegionCellAddress;
        String cellValue = cell.getStringCellValue();
        CellAddress cellAddress = cell.getAddress();
        if (ExcelOperator.isMergedCell(sheet, cellAddress) && (mergedRegionCellAddress = ExcelOperator.getMergedRegionCellAddress(sheet, cellAddress)) != null) {
            cellValue = ExcelOperator.readCellValueAsString(sheet.getRow(mergedRegionCellAddress.getRow()).getCell(mergedRegionCellAddress.getColumn()));
        }
        return cellValue;
    }

    private static String readCellValueAsString(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return "";
    }

    private static boolean isMergedCell(Sheet sheet, CellAddress cellAddress) {
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            if (!sheet.getMergedRegion(i).isInRange(cellAddress)) continue;
            return true;
        }
        return false;
    }

    private static CellAddress getMergedRegionCellAddress(Sheet sheet, CellAddress cellAddress) {
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = sheet.getMergedRegion(i);
            if (!region.isInRange(cellAddress)) continue;
            return new CellAddress(region.getFirstRow(), region.getFirstColumn());
        }
        return null;
    }
}

