/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.auth;

import cn.funnymap.lgis.auth.UserBasicInfo;
import java.util.Optional;

public class UserBasicInfoContext {
    private static final ThreadLocal<UserBasicInfo> THREAD_LOCAL = new ThreadLocal();

    private UserBasicInfoContext() {
    }

    public static <T extends UserBasicInfo> void setCurrentUserInfo(T userBasicInfo) {
        THREAD_LOCAL.set(userBasicInfo);
    }

    public static Optional<UserBasicInfo> getCurrentUserBasicInfo() {
        return Optional.ofNullable(THREAD_LOCAL.get());
    }

    public static Optional<String> getCurrentUserId() {
        UserBasicInfo userBasicInfo = UserBasicInfoContext.getCurrentUserBasicInfo().orElse(new UserBasicInfo());
        return Optional.ofNullable(userBasicInfo.getUserId());
    }

    public static Optional<String> getCurrentUserName() {
        UserBasicInfo userBasicInfo = UserBasicInfoContext.getCurrentUserBasicInfo().orElse(new UserBasicInfo());
        return Optional.ofNullable(userBasicInfo.getUserName());
    }

    public static Optional<String[]> getCurrentUserRoles() {
        UserBasicInfo userBasicInfo = UserBasicInfoContext.getCurrentUserBasicInfo().orElse(new UserBasicInfo());
        return Optional.ofNullable(userBasicInfo.getRoles());
    }

    public static void unload() {
        THREAD_LOCAL.remove();
    }
}

