/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.response;

import cn.funnymap.lgis.response.ResponseStructure;
import cn.funnymap.lgis.response.exception.AbstractException;
import cn.funnymap.lgis.response.exception.common.BaseException;
import cn.funnymap.lgis.response.exception.common.ParamValidationException;
import cn.funnymap.lgis.response.status.code.BaseStatusEnum;
import cn.funnymap.lgis.response.status.code.ValidationExceptionStatusCodeEnum;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ConditionalOnClass(value={RestController.class})
@RestControllerAdvice(annotations={RestController.class})
public class GlobalResponseAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(GlobalResponseAdvice.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        ResponseStructure<Object> responseStructure;
        if (body instanceof InputStreamResource) {
            return body;
        }
        if (body instanceof byte[]) {
            return body;
        }
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        switch (((ServletServerHttpRequest)request).getServletRequest().getMethod().toUpperCase()) {
            case "POST": {
                response.setStatusCode(HttpStatus.CREATED);
                responseStructure = ResponseStructure.created("\u8d44\u6e90\u521b\u5efa\u6210\u529f");
                break;
            }
            case "PUT": {
                responseStructure = ResponseStructure.success("\u8d44\u6e90\u66f4\u65b0\u6210\u529f");
                break;
            }
            case "DELETE": {
                responseStructure = ResponseStructure.success("\u8d44\u6e90\u5220\u9664\u6210\u529f");
                break;
            }
            default: {
                responseStructure = ResponseStructure.success();
            }
        }
        responseStructure.setData(body);
        if (returnType.getParameterType() == String.class) {
            return JSONObject.toJSONString(responseStructure, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        responseStructure.setData(body);
        return responseStructure;
    }

    @ExceptionHandler(value={AbstractException.class})
    public ResponseEntity<ResponseStructure<String>> handleCustomException(AbstractException customException) {
        this.writeExceptionToLog(customException);
        ResponseStructure<String> responseStructure = ResponseStructure.fail(customException);
        return new ResponseEntity(responseStructure, customException.getHttpStatus());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ResponseStructure<String>> handleCustomException(ConstraintViolationException exception) {
        List msgList = exception.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
        ParamValidationException paramValidationException = new ParamValidationException(ValidationExceptionStatusCodeEnum.ERR_INVALID_REQUEST_PARAMS, String.join((CharSequence)"\uff1b", msgList));
        this.writeExceptionToLog(paramValidationException);
        ResponseStructure<String> responseStructure = ResponseStructure.fail(paramValidationException);
        return new ResponseEntity(responseStructure, paramValidationException.getHttpStatus());
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<ResponseStructure<String>> handleValidationException(ValidationException exception) {
        ParamValidationException paramValidationException = new ParamValidationException(ValidationExceptionStatusCodeEnum.ERR_INVALID_REQUEST_PARAMS, exception.getMessage());
        this.writeExceptionToLog(paramValidationException);
        ResponseStructure<String> responseStructure = ResponseStructure.fail(paramValidationException);
        return new ResponseEntity(responseStructure, paramValidationException.getHttpStatus());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<ResponseStructure<String>> handle(BindException exception) {
        String message = ((ObjectError)exception.getBindingResult().getAllErrors().get(0)).getDefaultMessage();
        ParamValidationException paramValidationException = new ParamValidationException(ValidationExceptionStatusCodeEnum.ERR_INVALID_REQUEST_PARAMS, message);
        this.writeExceptionToLog(paramValidationException);
        ResponseStructure<String> responseStructure = ResponseStructure.fail(paramValidationException);
        return new ResponseEntity(responseStructure, paramValidationException.getHttpStatus());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ResponseStructure<String>> handle(Exception exception) {
        BaseException baseException = new BaseException(BaseStatusEnum.ERR_UNKNOWN, exception.getMessage());
        this.writeExceptionToLog(baseException);
        ResponseStructure<String> responseStructure = ResponseStructure.fail(baseException);
        return new ResponseEntity(responseStructure, baseException.getHttpStatus());
    }

    private void writeExceptionToLog(AbstractException exception) {
        log.error(String.format("\u9519\u8bef\u4ee3\u7801\uff1a%d\uff0c\u9519\u8bef\u63cf\u8ff0\u4fe1\u606f\uff1a%s", exception.getCode(), exception.getMessage()), (Throwable)exception);
    }
}

