/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.params.validation;

import cn.funnymap.lgis.params.DateRange;
import cn.funnymap.lgis.params.validation.DateRangeValidation;
import cn.funnymap.lgis.utils.DateUtil;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Date;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

@ConditionalOnClass(value={Constraint.class})
public class DateRangeValidator
implements ConstraintValidator<DateRangeValidation, Object> {
    public void initialize(DateRangeValidation constraintAnnotation) {
        super.initialize((Annotation)constraintAnnotation);
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof DateRange) {
            DateRange dateRange = (DateRange)value;
            String startDate = dateRange.getStart();
            String endDate = dateRange.getEnd();
            if (startDate == null || endDate == null) {
                this.replaceErrorMessage(context, "\u8d77\u59cb\u65e5\u671f\u6216\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            try {
                Date start = DateUtil.str2date(startDate);
                Date end = DateUtil.str2date(endDate);
                if (start.after(end)) {
                    this.replaceErrorMessage(context, "\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f");
                    return false;
                }
            }
            catch (ParseException e) {
                this.replaceErrorMessage(context, "\u8d77\u59cb\u65e5\u671f\u6216\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u4fdd\u683c\u5f0f\u4e3ayyyy-MM-dd");
                return false;
            }
        }
        return true;
    }

    private void replaceErrorMessage(ConstraintValidatorContext context, String message) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }
}

