package cn.funnymap.lgis.response.status.code;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpStatus;

/**
 * 参数校验异常枚举
 *
 * @author jiaoxn
 */
@ConditionalOnClass(HttpStatus.class)
public enum ValidationExceptionStatusCodeEnum implements IStatusCode {
    ERR_INVALID_REQUEST_PARAMS(HttpStatus.BAD_REQUEST, 100400, "无效的请求参数"),
    ERR_WRONG_MULTIPART_FILE_TYPE(HttpStatus.BAD_REQUEST, 100401, "文件类型错误");

    private final HttpStatus httpStatus;
    private final Integer code;
    private final String message;

    ValidationExceptionStatusCodeEnum(HttpStatus httpStatus, Integer code, String message) {
        this.httpStatus = httpStatus;
        this.code = code;
        this.message = message;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }
}
