package cn.funnymap.lgis.response.status.code;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpStatus;

/**
 * 认证及授权异常枚举
 *
 * @author jiaoxn
 */
@ConditionalOnClass(HttpStatus.class)
public enum IAExceptionStatusCodeEnum implements IStatusCode {
    ERR_ENCRYPTION(HttpStatus.UNAUTHORIZED, 100200, "密码加密时发生错误"),
    ERR_INVALID_SIGNATURE(HttpStatus.UNAUTHORIZED, 100201, "无效的签名"),
    ERR_EXPIRED_TOKEN(HttpStatus.UNAUTHORIZED, 100202, "Token已过期"),
    ERR_INVALID_AUTH_HEADER(HttpStatus.UNAUTHORIZED, 100203, "无效的授权请求头"),
    ERR_EMPTY_AUTH_HEADER(HttpStatus.UNAUTHORIZED, 100204, "授权请求头为空"),
    ERR_INCORRECT_PASSWORD(HttpStatus.UNAUTHORIZED, 100205, "用户名或密码不正确"),
    ERR_PERMISSION_DENIED(HttpStatus.FORBIDDEN, 100206, "没有访问资源的权限");

    private final HttpStatus httpStatus;
    private final Integer code;
    private final String message;
    IAExceptionStatusCodeEnum(HttpStatus httpStatus, Integer code, String message) {
        this.httpStatus = httpStatus;
        this.code = code;
        this.message = message;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }
}
