package cn.funnymap.lgis.response.exception;

import cn.funnymap.lgis.response.status.code.IStatusCode;
import org.springframework.http.HttpStatus;

/**
 * 自定义异常基类
 *
 * @author jiaoxn
 */
public abstract class AbstractException extends RuntimeException {
    // HTTP状态码
    private final HttpStatus httpStatus;
    // 业务状态码
    private final Integer code;
    private final String message;

    protected AbstractException(IStatusCode exceptionEnum, String message) {
        super(message);

        this.httpStatus = exceptionEnum.getHttpStatus();
        this.code = exceptionEnum.getCode();
        this.message = message;
    }

    protected AbstractException(IStatusCode exceptionEnum) {
        super(exceptionEnum.getMessage());
        this.httpStatus = exceptionEnum.getHttpStatus();
        this.code = exceptionEnum.getCode();
        this.message = exceptionEnum.getMessage();
    }

    public HttpStatus getHttpStatus() {
        return httpStatus;
    }

    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}
