package cn.funnymap.lgis.params.validation;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 用于校验日期范围参数的注解
 *
 * @author jiaoxn
 */
@ConditionalOnClass(Constraint.class)
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = DateRangeValidator.class)
public @interface DateRangeValidation {
    String message() default "日期范围校验失败";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
