package cn.funnymap.lgis.mp.handler;

import cn.funnymap.lgis.auth.UserBasicInfo;
import cn.funnymap.lgis.auth.UserBasicInfoContext;
import com.alibaba.fastjson2.util.DateUtils;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * 基本信息处理器
 *
 * @author jiao xn
 */
@ConditionalOnClass(MetaObjectHandler.class)
@Component("mpMetaObjectHandler")
public class MpMetaObjectHandler implements MetaObjectHandler {
    private static final String CREATOR_ID = "creatorId";
    private static final String CREATOR_NAME = "creatorName";
    private static final String UPDATER_ID = "updaterId";
    private static final String UPDATER_NAME = "updaterName";
    private static final String CREATE_TIME = "createTime";
    private static final String UPDATE_TIME = "updateTime";

    @Override
    public void insertFill(MetaObject metaObject) {
        this.insertFillUserInfo(metaObject);
        this.insertFillTimeFiled(metaObject, CREATE_TIME);
        this.insertFillTimeFiled(metaObject, UPDATE_TIME);
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        this.updateFileUserInfo(metaObject);
        this.updateFileTimeFiled(metaObject);
    }

    private void insertFillUserInfo(MetaObject metaObject) {
        UserBasicInfo userInfoDto = this.getUserInfo();

        if (userInfoDto != null) {
            String userId = userInfoDto.getUserId();
            String userName = userInfoDto.getUserName();

            if (metaObject.hasSetter(CREATOR_ID)) {
                this.strictInsertFill(metaObject, CREATOR_ID, String.class, userId);
            }
            if (metaObject.hasSetter(CREATOR_NAME)) {
                this.strictInsertFill(metaObject, CREATOR_NAME, String.class, userName);
            }
            if (metaObject.hasSetter(UPDATER_ID)) {
                this.strictInsertFill(metaObject, UPDATER_ID, String.class, userId);
            }
            if (metaObject.hasSetter(UPDATER_NAME)) {
                this.strictInsertFill(metaObject, UPDATER_NAME, String.class, userName);
            }
        }
    }

    private void updateFileUserInfo(MetaObject metaObject) {
        UserBasicInfo userBasicInfo = this.getUserInfo();
        if (userBasicInfo != null) {
            String userId = userBasicInfo.getUserId();
            String userName = userBasicInfo.getUserName();

            if (metaObject.hasSetter(UPDATER_ID)) {
                this.setFieldValByName(UPDATER_ID, userId, metaObject);
            }
            if (metaObject.hasSetter(UPDATER_NAME)) {
                this.setFieldValByName(UPDATER_NAME, userName, metaObject);
            }
        }
    }

    private UserBasicInfo getUserInfo() {
        return UserBasicInfoContext.getCurrentUserBasicInfo();
    }

    private void insertFillTimeFiled(MetaObject metaObject, String timeFileName) {
        if (metaObject.hasSetter(timeFileName)) {
            if (metaObject.getSetterType(timeFileName).equals(Date.class)) {
                this.strictInsertFill(metaObject, timeFileName, Date.class, currentDate());
            } else if (metaObject.getSetterType(timeFileName).equals(LocalDateTime.class)) {
                this.strictInsertFill(metaObject, timeFileName, LocalDateTime.class, currentLocalDateTime());
            }
        }
    }

    private void updateFileTimeFiled(MetaObject metaObject) {
        if (metaObject.hasSetter(MpMetaObjectHandler.UPDATE_TIME)) {
            if (metaObject.getSetterType(MpMetaObjectHandler.UPDATE_TIME).equals(Date.class)) {
                this.strictUpdateFill(metaObject, MpMetaObjectHandler.UPDATE_TIME,Date.class, currentDate());
            } else if (metaObject.getSetterType(MpMetaObjectHandler.UPDATE_TIME).equals(LocalDateTime.class)) {
                this.strictUpdateFill(metaObject, MpMetaObjectHandler.UPDATE_TIME, LocalDateTime.class, currentLocalDateTime());
            }
        }
    }

    private Date currentDate() {
        return DateUtils.parseDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
    }

    private LocalDateTime currentLocalDateTime() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return LocalDateTime.parse(dateTimeFormatter.format(LocalDateTime.now()), dateTimeFormatter);
    }
}
