package cn.funnymap.lgis.mp.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;
import org.postgresql.util.PGobject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * JSON数据类型处理器
 *
 * @author jiao xn
 */
@ConditionalOnClass(BaseTypeHandler.class)
@MappedTypes({JSONObject.class})
public class JsonbTypeHandler extends BaseTypeHandler<JSONObject> {
    private static final PGobject JSON_OBJECT = new PGobject();

    @Override
    public void setNonNullParameter(PreparedStatement preparedStatement, int i, JSONObject jsonObject, JdbcType jdbcType)
            throws SQLException {
        if (preparedStatement != null) {
            JSON_OBJECT.setType("jsonb");
            JSON_OBJECT.setValue(JSON.toJSONString(jsonObject));
            preparedStatement.setObject(i, JSON_OBJECT);
        }
    }

    @Override
    public JSONObject getNullableResult(ResultSet resultSet, String s) throws SQLException {
        return JSONObject.parse(resultSet.getString(s));
    }

    @Override
    public JSONObject getNullableResult(ResultSet resultSet, int i) throws SQLException {
        return JSONObject.parse(resultSet.getString(i));
    }

    @Override
    public JSONObject getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        return JSONObject.parse(callableStatement.getString(i));
    }
}
