package cn.funnymap.lgis.mp.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.Version;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * MyBatis Plus基础实体
 *
 * @author jiaoxn
 */
@Data
public class BaseEntity implements Serializable {
    private Boolean isVisible;
    @TableLogic(value = "false", delval = "true")
    private Boolean isDeleted;

    @TableField(value = "creator_id", fill = FieldFill.INSERT)
    private String creatorId;
    @TableField(value = "creator_name", fill = FieldFill.INSERT)
    private String creatorName;
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @TableField(value = "updater_id", fill = FieldFill.INSERT)
    private String updaterId;
    @TableField(value = "updater_name", fill = FieldFill.INSERT)
    private String updaterName;
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @Version
    private Integer version;
}
