package cn.funnymap.lgis.auth;

import com.alibaba.fastjson2.JSONObject;

/**
 * 用户信息上下文
 *
 * @author jiao xn
 */
public class UserBasicInfoContext {
    private UserBasicInfoContext() {}

    private static final ThreadLocal<UserBasicInfo> THREAD_LOCAL = new ThreadLocal<>();

    public static void setCurrentUserInfo(String userInfo){
        UserBasicInfo userBasicInfo = userInfo != null ? JSONObject.parseObject(userInfo, UserBasicInfo.class) : null;
        THREAD_LOCAL.set(userBasicInfo);
    }

    public static UserBasicInfo getCurrentUserBasicInfo(){
        return THREAD_LOCAL.get();
    }

    public static void unload() {
        THREAD_LOCAL.remove();
    }
}
