package cn.funnymap.lgis.auth;

import com.alibaba.fastjson2.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 用户基本信息
 *
 * @author jiao xn
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserBasicInfo {
    // 用户ID
    private String userId;

    // 用户名
    private String userName;

    public static UserBasicInfo fromJsonStr(String jsonStr) {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return new UserBasicInfo(null, null);
        }

        return JSONObject.parseObject(jsonStr, UserBasicInfo.class);
    }
}
