/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.response;

import cn.funnymap.lgis.response.exception.AbstractException;
import cn.funnymap.lgis.response.status.StatusEnum;
import cn.funnymap.lgis.response.status.code.BaseStatusEnum;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;

public class ResponseStructure<T> {
    private static final String SUCCESS_STATUS = "success";
    private static final String FAIL_STATUS = "fail";
    private int code;
    private String status;
    private String message;
    private T data;

    private ResponseStructure(Integer code, String status, String message, T data) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public static <T> ResponseStructure<T> success(Integer code, String message, T data) {
        return new ResponseStructure<T>(code, SUCCESS_STATUS, message, data);
    }

    public static <T> ResponseStructure<T> success(String message) {
        return ResponseStructure.success(BaseStatusEnum.OK.getCode(), message, null);
    }

    public static <T> ResponseStructure<T> success(T data) {
        return ResponseStructure.success(BaseStatusEnum.OK.getCode(), BaseStatusEnum.OK.getMessage(), data);
    }

    public static <T> ResponseStructure<T> success() {
        return ResponseStructure.success(BaseStatusEnum.OK.getCode(), BaseStatusEnum.OK.getMessage(), null);
    }

    public static <T> ResponseStructure<T> created() {
        return ResponseStructure.created(BaseStatusEnum.CREATED.getMessage());
    }

    public static <T> ResponseStructure<T> created(String message) {
        return new ResponseStructure<Object>(BaseStatusEnum.CREATED.getCode(), SUCCESS_STATUS, message, null);
    }

    public static ResponseStructure<String> fail(Integer code, String message) {
        return new ResponseStructure<Object>(code, FAIL_STATUS, message, null);
    }

    public static ResponseStructure<String> fail(AbstractException exception) {
        return ResponseStructure.fail(exception.getCode(), exception.getMessage());
    }

    public static <T> ResponseStructure<T> instance(Integer code, StatusEnum statusEnum, String message, T data) {
        return new ResponseStructure<T>(code, statusEnum.getValue(), message, data);
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    public int getCode() {
        return this.code;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseStructure)) {
            return false;
        }
        ResponseStructure other = (ResponseStructure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseStructure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

