package cn.funnymap.lgis.response.status.code;

import org.springframework.http.HttpStatus;

/**
 * 数据库异常枚举
 *
 * @author jiaoxn
 */
public enum DatabaseExceptionStatusCodeEum implements IStatusCode {
    ERR_DATABASE(HttpStatus.INTERNAL_SERVER_ERROR, 100100, "数据库异常");

    private final HttpStatus httpStatus;
    private final Integer code;
    private final String message;
    DatabaseExceptionStatusCodeEum(HttpStatus httpStatus, Integer code, String message) {
        this.httpStatus = httpStatus;
        this.code = code;
        this.message = message;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }
}
