package cn.funnymap.lgis.response.status.code;

import org.springframework.http.HttpStatus;

/**
 * 基本异常枚举
 *
 * @author jiaoxn
 */
public enum BaseStatusEnum implements IStatusCode {
    OK(HttpStatus.OK, 100000, "资源请求成功"),
    CREATED(HttpStatus.CREATED, 100001, "资源创建成功"),
    ERR_UNKNOWN(HttpStatus.INTERNAL_SERVER_ERROR, 100002, "服务内部错误"),
    ERR_RESOURCE_NOT_FOUND(HttpStatus.NOT_FOUND, 100003, "您访问的资源不存在");

    private final HttpStatus httpStatus;
    private final Integer code;
    private final String message;
    BaseStatusEnum(HttpStatus httpStatus, Integer code, String message) {
        this.httpStatus = httpStatus;
        this.code = code;
        this.message = message;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }
}
