/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.response;

import cn.funnymap.lgis.response.ResponseStructure;
import cn.funnymap.lgis.response.exception.AbstractException;
import cn.funnymap.lgis.response.exception.common.BaseException;
import cn.funnymap.lgis.response.exception.common.ParamValidationException;
import cn.funnymap.lgis.response.status.code.BaseStatusEnum;
import cn.funnymap.lgis.response.status.code.ValidationExceptionStatusCodeEnum;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice(annotations={RestController.class})
public class GlobalResponseAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(GlobalResponseAdvice.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof InputStreamResource) {
            return body;
        }
        if (body instanceof byte[]) {
            return body;
        }
        if (body == null) {
            return ResponseStructure.success(null);
        }
        ResponseStructure<Object> responseStructure = "POST".equals(((ServletServerHttpRequest)request).getServletRequest().getMethod()) ? ResponseStructure.created() : ResponseStructure.success();
        responseStructure.setData(body);
        if (body instanceof String) {
            return JSONObject.toJSONString(responseStructure, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        responseStructure.setData(body);
        return responseStructure;
    }

    @ExceptionHandler(value={AbstractException.class})
    public ResponseEntity<ResponseStructure<String>> handleCustomException(AbstractException customException) {
        this.writeExceptionToLog(customException);
        ResponseStructure<String> responseStructure = ResponseStructure.fail(customException);
        return new ResponseEntity(responseStructure, customException.getHttpStatus());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ResponseStructure<String>> handleCustomException(ConstraintViolationException exception) {
        List msgList = exception.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
        ParamValidationException paramValidationException = new ParamValidationException(ValidationExceptionStatusCodeEnum.ERR_WRONG_MULTIPART_FILE_TYPE, String.join((CharSequence)"\uff1b", msgList));
        this.writeExceptionToLog(paramValidationException);
        ResponseStructure<String> responseStructure = ResponseStructure.fail(paramValidationException);
        return new ResponseEntity(responseStructure, paramValidationException.getHttpStatus());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ResponseStructure<String>> handle(Exception exception) {
        BaseException baseException = new BaseException(BaseStatusEnum.ERR_UNKNOWN, exception.getMessage());
        this.writeExceptionToLog(baseException);
        ResponseStructure<String> responseStructure = ResponseStructure.fail(baseException);
        return new ResponseEntity(responseStructure, baseException.getHttpStatus());
    }

    private void writeExceptionToLog(AbstractException exception) {
        log.error(String.format("\u9519\u8bef\u4ee3\u7801\uff1a%d\uff0c\u9519\u8bef\u63cf\u8ff0\u4fe1\u606f\uff1a%s", exception.getCode(), exception.getMessage()), (Throwable)exception);
    }
}

