package cn.funnymap.lgis.response;

import cn.funnymap.lgis.response.exception.AbstractException;
import cn.funnymap.lgis.response.status.StatusEnum;
import cn.funnymap.lgis.response.status.code.BaseStatusEnum;
import lombok.Data;

/**
 * 统一响应结构体
 *
 * @author jiao xn
 */
@Data
public class ResponseStructure<T>{
    private static final String SUCCESS_STATUS = "success";
    private static final String FAIL_STATUS = "fail";

    /*-----------------------------------------Getter/Setter---------------------------------------------------------*/
    private int code;
    private String status;
    private String message;
    private T data;

    private ResponseStructure(Integer code, String status, String message, T data) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.data = data;
    }

    /*-------------------------------------------------操作成功--------------------------------------------------------*/
    public static <T> ResponseStructure<T> success(Integer code, String message, T data) {
        return new ResponseStructure<>(code, SUCCESS_STATUS, message, data);
    }
    public static <T> ResponseStructure<T> success(String message) {
        return success(BaseStatusEnum.OK.getCode(), message, null);
    }
    public static <T> ResponseStructure<T> success(T data) {
        return success(BaseStatusEnum.OK.getCode(), BaseStatusEnum.OK.getMessage(), data);
    }
    public static <T> ResponseStructure<T> success() {
        return success(BaseStatusEnum.OK.getCode(), BaseStatusEnum.OK.getMessage(), null);
    }

    public static <T> ResponseStructure<T> created() {
        return created(BaseStatusEnum.CREATED.getMessage());
    }
    public static <T> ResponseStructure<T> created(String message) {
        return new ResponseStructure<>(BaseStatusEnum.CREATED.getCode(), SUCCESS_STATUS, message,null);
    }

    /*-------------------------------------------------操作失败--------------------------------------------------------*/
    public static ResponseStructure<String> fail(Integer code, String message) {
        return new ResponseStructure<>(code, FAIL_STATUS, message, null);
    }
    public static ResponseStructure<String> fail(AbstractException exception) {
        return fail(exception.getCode(), exception.getMessage());
    }

    /*----------------------------------------------自定义响应信息-----------------------------------------------------*/
    public static <T> ResponseStructure<T> instance(Integer code, StatusEnum statusEnum, String message, T data) {
        return new ResponseStructure<>(code, statusEnum.getValue(), message, data);
    }
}
