/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.response;

import cn.funnymap.lgis.response.exception.AbstractException;
import cn.funnymap.lgis.response.status.StatusEnum;
import cn.funnymap.lgis.response.status.code.BaseStatusEnum;

public class ResponseStructure<T> {
    private static final String SUCCESS_STATUS = "success";
    private static final String FAIL_STATUS = "fail";
    private int code;
    private String status;
    private String message;
    private T data;

    private ResponseStructure(Integer code, String status, String message, T data) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static <T> ResponseStructure<T> success(Integer code, String message, T data) {
        return new ResponseStructure<T>(code, SUCCESS_STATUS, message, data);
    }

    public static <T> ResponseStructure<T> success(String message) {
        return ResponseStructure.success(BaseStatusEnum.OK.getCode(), message, null);
    }

    public static <T> ResponseStructure<T> success(T data) {
        return ResponseStructure.success(BaseStatusEnum.OK.getCode(), BaseStatusEnum.OK.getMessage(), data);
    }

    public static <T> ResponseStructure<T> success() {
        return ResponseStructure.success(BaseStatusEnum.OK.getCode(), BaseStatusEnum.OK.getMessage(), null);
    }

    public static <T> ResponseStructure<T> created() {
        return ResponseStructure.created(BaseStatusEnum.CREATED.getMessage());
    }

    public static <T> ResponseStructure<T> created(String message) {
        return new ResponseStructure<Object>(BaseStatusEnum.CREATED.getCode(), SUCCESS_STATUS, message, null);
    }

    public static ResponseStructure<String> fail(Integer code, String message) {
        return new ResponseStructure<Object>(code, FAIL_STATUS, message, null);
    }

    public static ResponseStructure<String> fail(AbstractException exception) {
        return ResponseStructure.fail(exception.getCode(), exception.getMessage());
    }

    public static <T> ResponseStructure<T> instance(Integer code, StatusEnum statusEnum, String message, T data) {
        return new ResponseStructure<T>(code, statusEnum.getValue(), message, data);
    }
}

