package cn.funnymap.lgis.params.validation;


import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * MultipartFile文件扩展名校验注解
 *
 * @author jiaoxn
 */
@Constraint(validatedBy = { MultipartFileExtensionValidator.class })
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.PARAMETER, ElementType.FIELD})
public @interface MultipartFileExtensionAnno {
    String[] value();
    String message() default "请上传指定类型的文件";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
