package cn.funnymap.lgis.params;

import javax.validation.constraints.NotNull;

/**
 * 分页查询请求参数基类
 *
 * @author jiaoxn
 */
public class PageQueryRequest {
    @NotNull(message = "分页页码不可为空")
    private Integer page;
    @NotNull(message = "分页大小不可为空")
    private Integer pageSize;
    private String name;

    public PageQueryRequest() {}

    public PageQueryRequest(Integer page, Integer pageSize, String name) {
        this.page = page;
        this.pageSize = pageSize;
        this.name = name;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
