/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.controller.response.core;

import cn.funnymap.lgis.controller.response.enums.HttpStatusCodeEnum;
import cn.funnymap.lgis.controller.response.enums.IStatusCode;

public class ResponseStructure<T> {
    private static final String SUCCESS_STATUS = "success";
    private static final String FAIL_STATUS = "fail";
    private Integer code;
    private String status;
    private String message;
    private T data;

    public ResponseStructure(Integer code, String status, String message, T data) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public ResponseStructure(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static <T> ResponseStructure<T> success(Integer code, String message, T data) {
        return new ResponseStructure<T>(code, SUCCESS_STATUS, message, data);
    }

    public static <T> ResponseStructure<T> success(String message) {
        return ResponseStructure.success(HttpStatusCodeEnum.SUCCESS_200.getCode(), message, null);
    }

    public static <T> ResponseStructure<T> success(T data) {
        return ResponseStructure.success(HttpStatusCodeEnum.SUCCESS_200.getCode(), HttpStatusCodeEnum.SUCCESS_200.getMessage(), data);
    }

    public static <T> ResponseStructure<T> created(String message) {
        return new ResponseStructure<Object>(HttpStatusCodeEnum.CREATED_201.getCode(), SUCCESS_STATUS, message, null);
    }

    public static ResponseStructure<String> fail(Integer code, String message) {
        return new ResponseStructure<Object>(code, FAIL_STATUS, message, null);
    }

    public static ResponseStructure<String> fail(IStatusCode errorResult) {
        return ResponseStructure.fail(errorResult.getCode(), errorResult.getMessage());
    }

    public static ResponseStructure<String> internalServerError(String message) {
        return ResponseStructure.fail(HttpStatusCodeEnum.INTERNAL_SERVER_ERROR_500.getCode(), message);
    }

    public static ResponseStructure<String> invalidParameter(String message) {
        return ResponseStructure.fail(HttpStatusCodeEnum.INVALID_REQUEST_400.getCode(), message);
    }

    public static ResponseStructure<String> unauthorized(String message) {
        return ResponseStructure.fail(HttpStatusCodeEnum.UNAUTHORIZED_401.getCode(), message);
    }

    public static ResponseStructure<String> forbidden(String message) {
        return ResponseStructure.fail(HttpStatusCodeEnum.FORBIDDEN_403.getCode(), message);
    }

    public static ResponseStructure<String> notFound(String message) {
        return ResponseStructure.fail(HttpStatusCodeEnum.NOT_FOUND_404.getCode(), message);
    }

    public static <T> ResponseStructure<T> instance(Integer code, String message, T data) {
        ResponseStructure<T> responseStructure = new ResponseStructure<T>(code, message, data);
        if (code >= 300) {
            responseStructure.setStatus(FAIL_STATUS);
        } else {
            responseStructure.setStatus(SUCCESS_STATUS);
        }
        return responseStructure;
    }

    public static <T> ResponseStructure<T> instance(Integer code, String message) {
        return ResponseStructure.instance(code, message, null);
    }

    public static <T> ResponseStructure<T> instance(IStatusCode responseStatusCode) {
        return ResponseStructure.instance(responseStatusCode.getCode(), responseStatusCode.getMessage());
    }
}

