/*
 * Decompiled with CFR 0.152.
 */
package cn.funnymap.lgis.controller.exception;

import cn.funnymap.lgis.controller.exception.AbstractException;
import cn.funnymap.lgis.controller.response.core.ResponseStructure;
import cn.funnymap.lgis.controller.response.enums.HttpStatusCodeEnum;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@Order(value=-2147483647)
@RestControllerAdvice
public class ExceptionAdvice {
    @ExceptionHandler(value={AbstractException.class})
    public ResponseStructure<String> handleCustomException(AbstractException customException) {
        return ResponseStructure.instance(customException.getBusinessStatusCode(), customException.getMessage());
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseStructure<String> handleMaxUploadSizeException(MaxUploadSizeExceededException ignoredMaxUploadSizeExceededException) {
        return ResponseStructure.invalidParameter("\u5f53\u524d\u6587\u4ef6\u5927\u5c0f\u5df2\u8d85\u8fc7\u9650\u5236\u5927\u5c0f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6");
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public ResponseStructure<String> handle(Exception exception) {
        return ResponseStructure.fail(HttpStatusCodeEnum.INTERNAL_SERVER_ERROR_500.getCode(), exception.getMessage());
    }
}

