/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.web.validation;

import cn.fscode.commons.core.config.ValidatorProperties;
import cn.fscode.commons.core.validation.EnumValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={ValidatorProperties.class})
public class ValidationConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ValidationConfig.class);
    private static ValidatorProperties validatorProper;
    @Resource
    private ValidatorProperties validatorProperties;
    private static final Map<String, String> VALIDATION_ANNATATION_DEFAULT_MESSAGES;
    private static final Map<String, String> enumMessage;

    @PostConstruct
    public void init() {
        validatorProper = this.validatorProperties;
    }

    public org.springframework.validation.Validator getValidator() {
        LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();
        localValidatorFactoryBean.setMessageInterpolator((javax.validation.MessageInterpolator)new MessageInterpolator());
        return localValidatorFactoryBean;
    }

    private static <E> E[] values(Class<E> enumClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method valuesMethod = enumClass.getMethod("values", new Class[0]);
        Object valuesObj = valuesMethod.invoke(enumClass, new Object[0]);
        return (Object[])valuesObj;
    }

    public static String getEnumMessage(Class<? extends Enum<?>> aClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Enum<?>[] values = ValidationConfig.values(aClass);
        StringBuilder sb = new StringBuilder();
        for (Enum<?> value : values) {
            Method getDesc = value.getClass().getMethod("getDesc", new Class[0]);
            String desc = (String)getDesc.invoke(value, new Object[0]);
            Method getCode = value.getClass().getMethod("getCode", new Class[0]);
            Object code = getCode.invoke(value, new Object[0]);
            sb.append(code);
            if (!StringUtils.isEmpty((CharSequence)desc)) {
                sb.append("(").append(desc).append(")");
            }
            sb.append(",");
        }
        sb.replace(sb.lastIndexOf(","), sb.length(), "");
        return sb.toString();
    }

    @Bean
    public Validator validator() {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory();
        return validatorFactory.getValidator();
    }

    static {
        VALIDATION_ANNATATION_DEFAULT_MESSAGES = new HashMap<String, String>(20){
            {
                this.put("xxx", "validation.message.notNull");
            }
        };
        enumMessage = new ConcurrentHashMap<String, String>(32){
            {
                this.put("EnumValue", "");
            }
        };
    }

    private static class MessageInterpolator
    extends ResourceBundleMessageInterpolator {
        private static final String ENUM_VALUE = "EnumValue";

        private MessageInterpolator() {
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            String annotationDefaultMessageCode;
            String annotationTypeName = context.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
            if (validatorProper.getIsAddEnumValue().booleanValue() && ENUM_VALUE.equals(annotationTypeName)) {
                EnumValue enumValue = (EnumValue)context.getConstraintDescriptor().getAnnotation();
                Class aClass = enumValue.enumClass();
                String name = aClass.getName();
                String result = (String)enumMessage.get(name);
                if (StringUtils.isEmpty((CharSequence)result)) {
                    try {
                        result = ValidationConfig.getEnumMessage(aClass);
                        enumMessage.put(name, result);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                        e.printStackTrace();
                    }
                }
                message = message + " [" + result + "]";
            }
            if (null != (annotationDefaultMessageCode = (String)VALIDATION_ANNATATION_DEFAULT_MESSAGES.get(annotationTypeName)) && !message.startsWith("javax.validation") && !message.startsWith("org.hibernate.validator.constraints")) {
                message = message + "{" + annotationDefaultMessageCode + "}";
            }
            return super.interpolate(message, context, locale);
        }
    }
}

