/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.web.handler;

import cn.fscode.commons.core.response.Resp;
import cn.fscode.commons.tool.core.exception.BaseException;
import cn.fscode.commons.tool.core.exception.BizException;
import com.alibaba.fastjson2.JSON;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@RestController
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @PostConstruct
    public void init() {
        log.info("init {}", (Object)this.getClass().getName());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Object noHandlerFoundException(HttpServletRequest req, Exception e) {
        log.error("exception: {}, uri: {}", (Object)e.getMessage(), (Object)req.getRequestURI());
        return Resp.fail((Integer)HttpStatus.NOT_FOUND.value(), (String)"Requested resource does not exist").wrap();
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Object missingServletRequestParameterException(HttpServletRequest req, MissingServletRequestParameterException e) {
        log.error("exception: {}, uri: {}", (Object)e.getMessage(), (Object)req.getRequestURI());
        return Resp.fail((String)(e.getParameterName() + ": " + e.getMessage())).wrap();
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Object methodArgumentTypeMismatchException(HttpServletRequest req, Exception e) {
        log.error("exception: {}, uri: {}", (Object)e.getMessage(), (Object)req.getRequestURI());
        return Resp.fail((String)"Method parameter types do not match").wrap();
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Object httpMessageNotReadableException(HttpServletRequest request, Exception e) {
        log.error("exception: {}, uri: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        return Resp.fail((String)"Message not readable").wrap();
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public Object bindException(Exception e, HttpServletRequest request) {
        StringBuilder errorMessageSb = new StringBuilder();
        HashMap<String, String> errorMap = new HashMap<String, String>(16);
        List allErrors = e instanceof MethodArgumentNotValidException ? ((MethodArgumentNotValidException)e).getBindingResult().getAllErrors() : ((BindException)e).getAllErrors();
        for (ObjectError oe : allErrors) {
            if (oe instanceof FieldError) {
                String message = String.format("%s: %s", ((FieldError)oe).getField(), oe.getDefaultMessage());
                errorMessageSb.append(message).append("; ");
                errorMap.put(((FieldError)oe).getField(), oe.getDefaultMessage());
                continue;
            }
            errorMap.put(oe.getObjectName(), oe.getDefaultMessage());
        }
        log.error("exception: {}, uri: {}", (Object)JSON.toJSONString(errorMap), (Object)request.getRequestURI());
        return Resp.fail((String)errorMessageSb.toString()).wrap();
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Object constraintViolationException(ConstraintViolationException e, HttpServletRequest request) {
        log.error("exception: {}, uri: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        StringBuilder sb = new StringBuilder();
        for (ConstraintViolation cv : e.getConstraintViolations()) {
            String path = ((PathImpl)cv.getPropertyPath()).getLeafNode().getName();
            String message = String.format("%s: %s", path, cv.getMessage());
            sb.append(message).append("; ");
        }
        return Resp.fail((String)sb.toString()).wrap();
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Object handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e, HttpServletRequest request, HttpServletResponse response) {
        log.error("exception: {}, uri: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        log.debug(e.getMessage(), (Throwable)e);
        String method = request.getMethod();
        return Resp.fail((Integer)HttpStatus.METHOD_NOT_ALLOWED.value(), (String)("Request method " + method + " is not supported")).wrap();
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Object handleHttpMediaTypeNotSupportedException(Exception e, HttpServletRequest request) {
        log.error("Unsupported Media Type, exception: {}, url: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        return Resp.fail((Integer)HttpStatus.UNSUPPORTED_MEDIA_TYPE.value(), (String)"Unsupported media type").wrap();
    }

    @ExceptionHandler(value={NullPointerException.class})
    public Object exceptionHandler(HttpServletRequest request, Exception e) {
        log.error("exception: {}, url: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        log.debug(e.getMessage(), (Throwable)e);
        return Resp.fail((String)"Server error").wrap();
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Object illegalArgumentException(HttpServletRequest request, Exception e) {
        log.error("exception: {}, url: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        log.debug(e.getMessage(), (Throwable)e);
        return Resp.fail((String)e.getMessage()).wrap();
    }

    @ExceptionHandler(value={BizException.class})
    public Object bizException(BizException e, HttpServletRequest request) {
        log.error("exception: {}, url: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        log.debug(e.getMessage(), (Throwable)e);
        return Resp.fail((Integer)e.getCode(), (String)e.getMessage()).wrap();
    }

    @ExceptionHandler(value={BaseException.class})
    public Object baseException(BaseException e, HttpServletRequest request) {
        log.error("exception: {}, url: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        log.debug(e.getMessage(), (Throwable)e);
        return Resp.fail((Integer)e.getCode(), (String)e.getMessage()).wrap();
    }

    @ExceptionHandler(value={Exception.class})
    public Object defaultExceptionHandler(Exception e, HttpServletRequest request) {
        log.error("exception: {}, url: {}", (Object)e.getMessage(), (Object)request.getRequestURI());
        log.debug(e.getMessage(), (Throwable)e);
        return Resp.fail((String)"Server error").wrap();
    }
}

