/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.tool.crypto.asymmetric;

import cn.fscode.commons.tool.crypto.asymmetric.AsymmetricCryptoType;
import cn.fscode.commons.tool.crypto.asymmetric.BaseAsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class RsaAsymmetricCrypto
extends BaseAsymmetricCrypto {
    public RsaAsymmetricCrypto() {
        RSA rsa = new RSA();
        this.publicKey = Base64.getEncoder().encodeToString(rsa.getPublicKey().getEncoded());
        this.privateKey = Base64.getEncoder().encodeToString(rsa.getPrivateKey().getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(String data, KeyType keyType) {
        RSA rsa;
        if (StringUtils.isEmpty((CharSequence)this.privateKey) || StringUtils.isEmpty((CharSequence)this.publicKey)) {
            RsaAsymmetricCrypto rsaAsymmetricCrypto = this;
            synchronized (rsaAsymmetricCrypto) {
                if (StringUtils.isEmpty((CharSequence)this.privateKey) || StringUtils.isEmpty((CharSequence)this.publicKey)) {
                    rsa = new RSA();
                    this.publicKey = Base64.getEncoder().encodeToString(rsa.getPublicKey().getEncoded());
                    this.privateKey = Base64.getEncoder().encodeToString(rsa.getPrivateKey().getEncoded());
                } else {
                    rsa = new RSA(this.privateKey, this.publicKey);
                }
            }
        } else {
            rsa = new RSA(this.privateKey, this.publicKey);
        }
        return rsa.decrypt(data, keyType);
    }

    @Override
    public AsymmetricCryptoType type() {
        return AsymmetricCryptoType.RSA;
    }
}

