/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.tool.crypto;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);
    private static String SECRET_KEY_OF_WXH = "e10adc3949ba59abbe56e057f20f883f";
    private static final String APPLICATION_JSON = "application/json";

    public static void setSecretKeyOfWxh(String secretKeyOfWxh) {
        SECRET_KEY_OF_WXH = secretKeyOfWxh;
    }

    public static String getSecretKeyOfWxh() {
        return SECRET_KEY_OF_WXH;
    }

    public static Boolean checkSign(Map<String, Object> params, String ts, String nonce, String sign, String secretKeyOfWxh) throws Exception {
        boolean flag = false;
        String verifySign = SignUtils.getSign(params, ts, nonce, secretKeyOfWxh);
        log.debug("\u73b0\u5728\u7684sign-->>" + sign);
        log.debug("\u9a8c\u8bc1\u7684sign-->>" + verifySign);
        if (sign.equals(verifySign)) {
            flag = true;
        }
        return flag;
    }

    public static String getSign(Map<String, Object> params, String ts, String nonce, String secret) throws IOException {
        String sign = "";
        StringBuilder sb = new StringBuilder();
        Set<String> keySet = params.keySet();
        TreeSet<String> sortSet = new TreeSet<String>(keySet);
        for (String key : sortSet) {
            Object value = params.get(key);
            sb.append(key).append(value);
        }
        sb.append(secret).append(ts).append(nonce);
        byte[] md5Digest = SignUtils.getMd5Digest(sb.toString());
        sign = SignUtils.byte2hex(md5Digest);
        return sign;
    }

    public static long getTimestamp() {
        long timestampLong = System.currentTimeMillis();
        return timestampLong / 1000L;
    }

    public static String utf8Encoding(String value, String sourceCharsetName) {
        try {
            return new String(value.getBytes(sourceCharsetName), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] getMd5Digest(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }
}

