package cn.fscode.commons.tool.core.exception;

import cn.hutool.core.util.StrUtil;

/**
 * 自定义异常
 *
 * @author shenguangyang
 */
public class BizException extends BaseException {
    private static final long serialVersionUID = 1L;

    public BizException(String message) {
        this.message = message;
    }

    public BizException(CharSequence template, Object... params) {
        this.message = StrUtil.format(template, params);
    }

    public BizException(BaseError baseError) {
        super(baseError);
    }

    public BizException(Integer code, String message) {
        this.message = message;
        this.code = code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public Integer getCode() {
        return code;
    }
}
