package cn.fscode.commons.tool.core.exception;

import cn.hutool.core.util.StrUtil;

/**
 * 基础异常
 * 
 * @author shenguangyang
 */
public class BaseException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    /**
     * 错误码
     */
    protected Integer code;

    /**
     * 错误消息
     */
    protected String message;

    /**
     * Constructs a new runtime exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     */
    public BaseException() {
    }

    public BaseException(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * 格式化文本, {} 表示占位符<br>
     * 此方法只是简单将占位符 {} 按照顺序替换为参数<br>
     * @param code 代码
     * @param msgTemplate 消息模板, eg: \\hello {}, age \\{}
     * @param msgValues 消息模板值: eg: java, 20
     */
    public BaseException(Integer code, String msgTemplate, Object... msgValues) {
        this.code = code;
        this.message = StrUtil.format(msgTemplate, msgValues);
    }

    /**
     * 格式化文本, {} 表示占位符<br>
     * 此方法只是简单将占位符 {} 按照顺序替换为参数<br>
     * @param msgTemplate 消息模板, eg: \\hello {}, age \\{}
     * @param msgValues 消息模板值: eg: java, 20
     */
    public BaseException(String msgTemplate, Object... msgValues) {
        this.message = StrUtil.format(msgTemplate, msgValues);
    }

    public BaseException(String message) {
        this.message = message;
    }

    public BaseException(BaseError baseError) {
        this.message = baseError.getMessage();
        this.code = baseError.getCode();
    }

    public Integer getCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
