package cn.fscode.commons.tool.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * 树形结构工具类
 * 将一组list对象转成树形结构
 * 对象中一定要包含两个树形，pid 父id ， child 孩子集合
 * @author shenguangyang
 */
public class TreeUtils {
    public static void main(String[] args) {
//        SystemInit systemMenu = new SystemInit();
////        systemMenu.setPid("234235443");
//        List<SystemInit> list = new ArrayList<>();
//        list.add(systemMenu);
//        toTree(list, SystemInit.class,"pid");
    }

    /**
     * @Description: 首字母转大写
     * @param str 字符串
     */
    private static String firstCharToUpperCase(String str){
        if(str == null){ return null; }
        if("".equals(str)){
            return "";
        }
        char[] cs = str.toCharArray();
        cs[0]-=32;
        return String.valueOf(cs);
    }
    /**
     * 构建属性结构
     * @param treeList 数据集合
     * @param tClass 类.class
     * @param parentIdField 父字段名字
     * @return 排序好的集合
     */
    public static <T> List<T> toTree(List<T> treeList, Class<T> tClass, String parentIdField) {
        // 通过反射获取方法
        List<T> retList = new ArrayList<T>();
        // 获取方法名,
        String getParentIdMethodName = "get" + firstCharToUpperCase(parentIdField);
        try {
            // 注：这里获取方法只能通过class，不能通过对象
            Method method = tClass.getDeclaredMethod(getParentIdMethodName);

            for (int i = 0; i < 100;i++) {
                Object invoke = method.invoke(treeList.get(0));
                System.out.println(invoke);
            }
            for (T parent : treeList) {
                Object invoke = method.invoke(parent);
                System.out.println(invoke);
            }

        } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return retList;
    }
}
