package cn.fscode.commons.mybatis.plus.config;


import com.baomidou.mybatisplus.autoconfigure.IdentifierGeneratorAutoConfiguration;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.github.yitter.idgen.YitIdHelper;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

/**
 * 自定全局唯一id生成器
 * @author shenguangyang
 */
@Component
@AutoConfigureBefore(IdentifierGeneratorAutoConfiguration.class)
@ConditionalOnExpression("${mybatis-plus.extend.customIdGenerator.enableYitId:false}")
public class CustomIdGenerator implements IdentifierGenerator {
    @Override
    public Long nextId(Object entity) {
        return YitIdHelper.nextId();
    }
}
