/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.mybatis.plus.utils;

import cn.fscode.commons.core.response.PageData;
import cn.fscode.commons.core.response.Resp;
import cn.fscode.commons.mybatis.plus.entity.PageDomain;
import cn.fscode.commons.mybatis.plus.entity.TableSupport;
import cn.fscode.commons.tool.core.CollectionUtils;
import cn.fscode.commons.tool.core.SqlUtils;
import cn.fscode.commons.tool.core.StringUtils;
import cn.fscode.commons.tool.core.exception.BizException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;

public class PageUtil {
    public static void startPage() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        if (!StringUtils.isNotNull((Object)pageNum) || !StringUtils.isNotNull((Object)pageSize)) {
            throw new BizException("Illegal parameter");
        }
        String orderBy = SqlUtils.escapeOrderBySql((String)pageDomain.getOrderBy());
        PageHelper.startPage((int)(pageNum <= 0 ? 1 : pageNum), (int)pageSize, (String)orderBy);
    }

    public static <T> Resp<PageData<T>> getDataTable(List<T> list) {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        long total = CollectionUtils.isEmpty(list) ? 0L : new PageInfo(list).getTotal();
        PageData pageData = new PageData();
        pageData.setPageNum(pageNum);
        pageData.setList(list);
        pageData.setPageSize(pageSize);
        pageData.setTotal(Long.valueOf(total));
        return Resp.ok((Object)pageData);
    }

    public static <T> Resp<PageData<T>> getDataTable(IPage<T> page) {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        List records = page.getRecords();
        long total = page.getTotal();
        PageData pageData = new PageData();
        pageData.setPageNum(pageNum);
        pageData.setList((Collection)records);
        pageData.setPageSize(pageSize);
        pageData.setTotal(Long.valueOf(total));
        return Resp.ok((Object)pageData);
    }
}

