/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.mybatis.plus.utils;

import com.mysql.cj.jdbc.MysqlDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataBaseInit {
    private static final Logger logger = LoggerFactory.getLogger(DataBaseInit.class);
    private static final String MYSQL8_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String MYSQL5_DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";

    private DataBaseInit() {
    }

    public static void initDb(String jdbcUrl, String driver, String username, String password, String initDb) throws ClassNotFoundException {
        MysqlDataSource dataSource = new MysqlDataSource();
        Class.forName(driver);
        String notDbJdbcUrl = jdbcUrl.replace("/" + initDb, "");
        dataSource.setUrl(notDbJdbcUrl);
        dataSource.setUser(username);
        dataSource.setPassword(password);
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        logger.info("JdbcTemplate = {}", (Object)jdbcTemplate);
        logger.info("jdbcUrl = {}, database = {}", (Object)jdbcUrl, (Object)initDb);
        if (MYSQL8_DRIVER_CLASS_NAME.equals(driver)) {
            jdbcTemplate.execute(String.format("CREATE DATABASE IF NOT EXISTS `%s` DEFAULT CHARACTER SET utf8mb4", initDb));
        } else if (MYSQL5_DRIVER_CLASS_NAME.equals(driver)) {
            jdbcTemplate.execute(String.format("CREATE DATABASE IF NOT EXISTS `%s` DEFAULT CHARACTER SET utf8", initDb));
        }
        logger.info("database [{}] create success", (Object)initDb);
    }
}

