/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.mybatis.plus;

import cn.fscode.commons.mybatis.plus.utils.DataBaseInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class MybatisInitPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(MybatisInitPostProcessor.class);
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        if (!this.isInitDb().booleanValue()) {
            return;
        }
        String driverClassName = this.getEnvironmentProperty("spring.datasource.driver-class-name");
        String jdbcUrl = this.getEnvironmentProperty("spring.datasource.url");
        String username = this.getEnvironmentProperty("spring.datasource.username");
        String password = this.getEnvironmentProperty("spring.datasource.password");
        String initDb = this.getDbNameFromUrl(jdbcUrl);
        log.info("initDb [{}] driverClassName [{}] jdbcUrl [{}] username [{}] password [{}]", new Object[]{initDb, driverClassName, jdbcUrl, username, password});
        try {
            DataBaseInit.initDb(jdbcUrl, driverClassName, username, password, initDb);
        }
        catch (ClassNotFoundException e) {
            log.error("database create failed, errorMessage [{}]", (Object)e.getMessage());
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private Boolean isInitDb() {
        String property = "mybatis-plus.extend.init-db";
        String value = this.environment.getProperty(property, "false");
        log.info("mybatis-plus.init-db: " + value);
        return Boolean.parseBoolean(value);
    }

    private String getEnvironmentProperty(String property) {
        String value = this.environment.getProperty(property);
        if (value == null) {
            throw new RuntimeException("property [ " + property + " ] is null");
        }
        return value;
    }

    private String getDbNameFromUrl(String url) {
        String regex;
        url = url.substring(url.indexOf("//") + 2);
        url = url.substring(url.indexOf("/") + 1);
        int i = url.indexOf("?");
        String dbName = "";
        dbName = i != -1 ? url.substring(0, i) : url;
        if (dbName.matches(regex = "^.*(=|&|/|\\\\).*$")) {
            throw new RuntimeException("url [ " + dbName + " ] is illegal");
        }
        return dbName;
    }
}

