package cn.fscode.commons.mybatis.plus.utils;

import cn.fscode.commons.mybatis.plus.entity.PageDomain;
import cn.fscode.commons.mybatis.plus.entity.TableSupport;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import cn.fscode.commons.core.response.PageData;
import cn.fscode.commons.core.response.Resp;
import cn.fscode.commons.tool.core.CollectionUtils;
import cn.fscode.commons.tool.core.SqlUtils;
import cn.fscode.commons.tool.core.StringUtils;
import cn.fscode.commons.tool.core.exception.BizException;

import java.util.List;

/**
 * 分页工具
 * @author shenguangyang
 */
public class PageUtil {
    /**
     * 设置请求分页数据
     */
    public static void startPage() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        if (StringUtils.isNotNull(pageNum) && StringUtils.isNotNull(pageSize)) {
            String orderBy = SqlUtils.escapeOrderBySql(pageDomain.getOrderBy());
            PageHelper.startPage(pageNum <= 0 ? 1 : pageNum, pageSize, orderBy);
        } else {
            throw new BizException("Illegal parameter");
        }
    }

    /**
     * 响应请求分页数据
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
    public static <T> Resp<PageData<T>> getDataTable(List<T> list) {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        long total = CollectionUtils.isEmpty(list) ? 0 : new PageInfo(list).getTotal();

        PageData<T> pageData = new PageData<>();
        pageData.setPageNum(pageNum);
        pageData.setList(list);
        pageData.setPageSize(pageSize);
        pageData.setTotal(total);
        return Resp.ok(pageData);
    }

    public static <T> Resp<PageData<T>> getDataTable(IPage<T> page) {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        List<T> records = page.getRecords();
        long total = page.getTotal();

        PageData<T> pageData = new PageData<>();
        pageData.setPageNum(pageNum);
        pageData.setList(records);
        pageData.setPageSize(pageSize);
        pageData.setTotal(total);
        return Resp.ok(pageData);
    }
}
