package cn.fscode.commons.mybatis.plus.config;

import cn.fscode.commons.mybatis.plus.constants.MybatisPlusConstants;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author shenguangyang
 */
@ConfigurationProperties(prefix = MybatisPlusConstants.MYBATIS_PLUS_EXTEND_PROPERTIES_PREFIX)
public class MybatisPlusExtendProperties {
    /**
     * 是否初始化db数据库, 只对单机版本数据库有效
     * 会自动解析url中数据库名并进行创建
     */
    private Boolean initDb = Boolean.FALSE;
    /**
     * 指定自动创建的数据库名, 无论是否指定, 如果 {@link #initDb} = true, 都会
     * 自动解析url并创建数据库
     * 多个数据库名用逗号分割
     *
     * 目前没有具体实现只是预留一个属性
     */
    private String autoCreateDbs;

    /**
     * 自定义id生成器配置
     */
    private CustomIdGenerator customIdGenerator;
    public static class CustomIdGenerator {
        /**
         * 是否使能采用漂移雪花算法生成数据库主键
         * 如果使用了自定义主键类型, 不需要指定type, @TableId(value = "demo_id")
         */
        private Boolean enableYitId;

        public CustomIdGenerator() {
            this.enableYitId = false;
        }

        public Boolean getEnableYitId() {
            return enableYitId;
        }

        public void setEnableYitId(Boolean enableYitId) {
            this.enableYitId = enableYitId;
        }
    }

    public CustomIdGenerator getCustomIdGenerator() {
        return customIdGenerator;
    }

    public void setCustomIdGenerator(CustomIdGenerator customIdGenerator) {
        this.customIdGenerator = customIdGenerator;
    }

    public Boolean getInitDb() {
        return initDb;
    }

    public void setInitDb(Boolean initDb) {
        this.initDb = initDb;
    }

    public String getAutoCreateDbs() {
        return autoCreateDbs;
    }

    public void setAutoCreateDbs(String autoCreateDbs) {
        this.autoCreateDbs = autoCreateDbs;
    }
}
