package cn.fscode.commons.mqtt;

import cn.fscode.commons.mqtt.config.MqttConsumerConfig;
import cn.fscode.commons.mqtt.config.MqttProducerConfig;
import cn.fscode.commons.mqtt.config.MqttProperties;
import cn.fscode.commons.mqtt.enable.EnableMqttBeanDefinitionRegistryPostProcessor;
import cn.fscode.commons.mqtt.enable.EnableMqttRegistrar;
import cn.fscode.commons.mqtt.enable.EnableMqtt;
import cn.fscode.commons.mqtt.service.MqttSendExpandServiceImpl;
import cn.fscode.commons.mqtt.service.MqttSendService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;
import org.springframework.integration.annotation.IntegrationComponentScan;

import javax.annotation.PostConstruct;

/**
 * @author shenguangyang
 */
@AutoConfiguration
@EnableMqtt(value = false)
@IntegrationComponentScan("cn.fscode.commons.mqtt")
@EnableConfigurationProperties(MqttProperties.class)
@ImportAutoConfiguration({MqttConsumerConfig.class, MqttProducerConfig.class})
@Import({
        EnableMqttBeanDefinitionRegistryPostProcessor.class, EnableMqttRegistrar.class,
        MqttSendExpandServiceImpl.class, MqttSendService.class
})
public class CommonsMqttAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CommonsMqttAutoConfiguration.class);

    @PostConstruct
    public void init() {
        log.info("init {}", this.getClass().getName());
    }
}
