/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.mq.api.enums;

import cn.fscode.commons.tool.core.exception.BizException;

public enum MqTypeEnum {
    ROCKETMQ("rocketmq"),
    MQTT("mqtt"),
    RABBITMQ("rabbitmq"),
    KAFKA("kafka");

    private final String type;

    private MqTypeEnum(String type) {
        this.type = type;
    }

    public static MqTypeEnum getByType(String type) {
        MqTypeEnum[] values;
        for (MqTypeEnum mqTypeEnum : values = MqTypeEnum.values()) {
            if (!mqTypeEnum.getType().equals(type)) continue;
            return mqTypeEnum;
        }
        return null;
    }

    public static void isSupported(String type) {
        MqTypeEnum[] values;
        for (MqTypeEnum mqTypeEnum : values = MqTypeEnum.values()) {
            if (!mqTypeEnum.getType().equals(type)) continue;
            return;
        }
        throw new BizException("mqType [ " + type + " ] not supported, support mqType [ " + ROCKETMQ.getType() + " , " + MQTT.getType() + " , " + KAFKA.getType() + " , " + RABBITMQ.getType() + " ]");
    }

    public String getType() {
        return this.type;
    }
}

