package cn.fscode.commons.mq.api;

import cn.fscode.commons.tool.core.StringUtils;

import java.io.Serializable;
import java.util.UUID;

/**
 * 消息实体需要继承该类
 * @author shenguangyang
 */
public class BaseMqMessage implements Serializable {
    /**
     * 消息id
     */
    protected String msgId;

    public String getMsgId() {
        // 如果当前this.msgId不为空则创建一个默认的
        if (StringUtils.isEmpty(this.msgId)) {
            // ac = auto create
            this.msgId = "ac-" + UUID.randomUUID().toString().replaceAll("-", "");
        }
        return msgId;
    }

    public boolean isEmptyOfMsgId() {
        return StringUtils.isEmpty(this.msgId);
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }
}
