package cn.fscode.commons.mock.data;

import cn.fscode.commons.mock.data.generator.MockDataRule;
import cn.fscode.commons.mock.data.generator.MockHelper;
import cn.fscode.commons.mock.data.generator.impl.DefaultMockDataRuleImpl;
import cn.fscode.commons.mock.data.generator.impl.DefaultTableMockDataGenerator;
import cn.fscode.commons.mock.data.manager.impl.GenMysqlDataManagerImpl;
import cn.fscode.commons.mock.data.manager.impl.MockDbDataManagerImpl;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

import javax.annotation.PostConstruct;

/**
 * @author shenguangyang
 */
@Slf4j
@Import({
        MockDbDataManagerImpl.class, GenMysqlDataManagerImpl.class, DefaultTableMockDataGenerator.class,
        MockHelper.class
})
@MapperScan(basePackages = "cn.fscode.commons.mock.data.mapper")
@AutoConfiguration
public class CommonsMockDataAutoConfiguration {

    @PostConstruct
    public void init() {
        log.info("init {}", this.getClass().getName());
    }

    @Bean
    @ConditionalOnMissingBean(MockDataRule.class)
    public MockDataRule mockDataRule() {
        return new DefaultMockDataRuleImpl();
    }
}
