/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.mock.data.manager.impl;

import cn.fscode.commons.mock.data.generator.MockDataGenerator;
import cn.fscode.commons.mock.data.generator.MockDataRule;
import cn.fscode.commons.mock.data.manager.GenMockDataManager;
import cn.fscode.commons.mock.data.manager.MockDbDataManager;
import cn.fscode.commons.mock.data.mapper.MockDbDataMapper;
import cn.fscode.commons.mock.data.model.MysqlTable;
import cn.fscode.commons.mock.data.model.MysqlTableColumn;
import cn.fscode.commons.tool.core.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockDbDataManagerImpl
implements MockDbDataManager {
    private static final Logger log = LoggerFactory.getLogger(MockDbDataManagerImpl.class);
    @Resource
    private MockDbDataMapper mockDbDataMapper;
    @Resource
    private MockDataRule mockDataRule;
    @Resource
    private GenMockDataManager genMockDataManager;
    @Resource
    private Map<String, MockDataGenerator> dataGeneratorMap;

    @Override
    public List<MysqlTable> listDbTable() {
        return MysqlTable.from(this.mockDbDataMapper.listTable());
    }

    @Override
    public List<MysqlTableColumn> listDbTableColumn(String tableName) {
        return MysqlTableColumn.from(this.mockDbDataMapper.listTableColumn(tableName));
    }

    @Override
    public int mockDataAndSave(String tableName, int num) {
        List<MysqlTableColumn> tableColumnList = MysqlTableColumn.from(this.mockDbDataMapper.listTableColumn(tableName));
        List<String> columnNameList = tableColumnList.stream().map(MysqlTableColumn::getColumnName).collect(Collectors.toList());
        ArrayList<List<Object>> columnDataList = new ArrayList<List<Object>>();
        Optional<MockDataGenerator> dataGenerator = this.dataGeneratorMap.values().stream().filter(v -> v.tableName().equals(tableName)).findFirst();
        for (int i = 0; i < num; ++i) {
            Map<String, Object> dataMap = this.genMockDataManager.create(dataGenerator.orElse(null), tableColumnList);
            columnDataList.add(columnNameList.stream().map(dataMap::get).collect(Collectors.toList()));
        }
        return this.mockDbDataMapper.batchInsert(tableName, columnNameList, columnDataList);
    }

    @Override
    public String createMockDataGeneratorCode(String tableName) {
        List<MysqlTableColumn> tableColumnList = MysqlTableColumn.from(this.mockDbDataMapper.listTableColumn(tableName));
        StringBuilder respSb = new StringBuilder();
        String className = StringUtils.convertToCamelCase((String)tableName);
        respSb.append("@Component").append("\n");
        respSb.append(String.format("public class %s implements MockDataGenerator {", className)).append("\n");
        respSb.append("\t@Override").append("\n");
        respSb.append("\tpublic String tableName() {").append("\n");
        respSb.append("\t\treturn ").append("\"").append(tableName).append("\"").append(";\n");
        respSb.append("\t}\n\n");
        respSb.append("\t@Override\n");
        respSb.append("\tpublic Map<String, Function<MysqlTableColumn, Object>> data() {\n");
        respSb.append("int random = RandomUtil.randomInt(1, 100);").append("\n");
        respSb.append("Map<String, Function<MysqlTableColumn, Object>> resp = new HashMap<>();").append("\n");
        tableColumnList.forEach(tableColumn -> {
            String dataType = tableColumn.getDataType();
            String columnKey = tableColumn.getColumnKey();
            respSb.append(String.format("/* dataType: %s, comment: %s */", tableColumn.getDataType(), tableColumn.getColumnComment())).append("\n");
            if (StringUtils.isNotEmpty((String)columnKey)) {
                respSb.append(String.format("resp.put(\"%s\", column -> YitIdHelper.nextId());", tableColumn.getColumnName()));
            } else if ("varchar".equals(dataType) || "text".equals(dataType) || "char".equals(dataType) || "blob".equals(dataType) || "tinytext".equals(dataType) || "tinyblob".equals(dataType)) {
                respSb.append(String.format("resp.put(\"%s\", MockHelper::mock);", tableColumn.getColumnName()));
            } else if ("datetime".equals(dataType)) {
                respSb.append(String.format("resp.put(\"%s\", column -> LocalDateTime.now());", tableColumn.getColumnName()));
            } else if ("date".equals(dataType)) {
                respSb.append(String.format("resp.put(\"%s\", column -> LocalDateTime.now());", tableColumn.getColumnName()));
            } else if ("bigint".equals(dataType)) {
                respSb.append(String.format("resp.put(\"%s\", MockHelper::mock);", tableColumn.getColumnName()));
            } else if ("int".equals(dataType) || "tinyint".equals(dataType)) {
                respSb.append(String.format("resp.put(\"%s\", column -> Double.valueOf(MockHelper.mock(column)));", tableColumn.getColumnName()));
            } else if ("float".equals(dataType)) {
                respSb.append(String.format("resp.put(\"%s\", column -> Float.valueOf(MockHelper.mock(column)));", tableColumn.getColumnName()));
            } else if ("double".equals(dataType)) {
                respSb.append(String.format("resp.put(\"%s\", MockHelper::mock);", tableColumn.getColumnName()));
            } else if ("decimal".equals(dataType)) {
                respSb.append(String.format("resp.put(\"%s\", column -> new BigDecimal(MockHelper.mock(column)));", tableColumn.getColumnName()));
            } else {
                log.warn("not find columnName [{}] dataType [{}]", (Object)tableColumn.getColumnName(), (Object)tableColumn.getDataType());
                respSb.append(String.format("resp.put(\"%s\", column -> \"1\");", tableColumn.getColumnName()));
            }
            respSb.append("\n");
        });
        respSb.append("return resp;");
        respSb.append("\t}\n");
        respSb.append("}\n");
        return respSb.toString();
    }
}

