/*
 * Decompiled with CFR 0.152.
 */
package cn.fscode.commons.mock.data.manager.impl;

import cn.fscode.commons.mock.data.generator.MockDataGenerator;
import cn.fscode.commons.mock.data.manager.GenMockDataManager;
import cn.fscode.commons.mock.data.model.MysqlTableColumn;
import cn.fscode.commons.tool.core.StringUtils;
import com.github.yitter.idgen.YitIdHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenMysqlDataManagerImpl
implements GenMockDataManager {
    private static final Logger log = LoggerFactory.getLogger(GenMysqlDataManagerImpl.class);

    @Override
    public Map<String, Object> create(MockDataGenerator mockDataGeneratorReq, List<MysqlTableColumn> tableColumnList) {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        Optional<MockDataGenerator> dataGenerator = Optional.ofNullable(mockDataGeneratorReq);
        tableColumnList.forEach(tableColumn -> {
            String dataType = tableColumn.getDataType();
            String columnKey = tableColumn.getColumnKey();
            if (StringUtils.isNotEmpty((String)columnKey)) {
                resp.put(tableColumn.getColumnName(), YitIdHelper.nextId());
            } else if ("varchar".equals(dataType) || "text".equals(dataType) || "char".equals(dataType) || "blob".equals(dataType) || "tinytext".equals(dataType) || "tinyblob".equals(dataType)) {
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse("1");
                resp.put(tableColumn.getColumnName(), data);
            } else if ("datetime".equals(dataType)) {
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse(LocalDateTime.now());
                resp.put(tableColumn.getColumnName(), data);
            } else if ("date".equals(dataType)) {
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse(LocalDateTime.now());
                resp.put(tableColumn.getColumnName(), data);
            } else if ("bigint".equals(dataType)) {
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse(1L);
                resp.put(tableColumn.getColumnName(), data);
            } else if ("int".equals(dataType) || "tinyint".equals(dataType)) {
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse(1);
                resp.put(tableColumn.getColumnName(), data);
            } else if ("float".equals(dataType)) {
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse(Float.valueOf(1.0f));
                resp.put(tableColumn.getColumnName(), data);
            } else if ("double".equals(dataType)) {
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse(BigDecimal.valueOf(1.0));
                resp.put(tableColumn.getColumnName(), data);
            } else if ("decimal".equals(dataType)) {
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse(BigDecimal.valueOf(1L));
                resp.put(tableColumn.getColumnName(), data);
            } else {
                log.warn("not find columnName [{}] dataType [{}]", (Object)tableColumn.getColumnName(), (Object)tableColumn.getDataType());
                Object data = dataGenerator.map(x -> x.data().get(tableColumn.getColumnName())).map(x -> x.apply(tableColumn)).orElse("1");
                resp.put(tableColumn.getColumnName(), data);
            }
        });
        return resp;
    }
}

